function [ signal ] = Chirp_Signal( B, Tp, Fs )
%%Chirp Signal Description
%**************************************************************************
%Chirp_Signal returns a complex chirp signal of the form:
%  s(t) = exp( j*pi*Alpha*t^2)
% Where Alpha = B/Tp (Bandwidth divided by Pulse width). A user should
% input B >> Tp, otherwise the Bandwidth of the signal will be dominated
% instead by the pulse width which in effect reduces the functionality of
% the linear frequency modulation.
%
% Author: William Rowe 
% Date: June 2011
% Version: 1.0
% Release: Public and Open Source 
% Purpose: CAL Waveform Analysis Toolkit
% 
% Inputs
%  B  : Bandwidth desired for the signal (Hz)
%  Tp : Pulse width of the signal (sec)
%  Fs : Sampling Frequency desired (Hz)
%
% Outputs
%  signal: complex chirp signal
%
%**************************************************************************
%%
 Alpha = B/Tp;
 Ts = 1/Fs;
 t = [0:Ts:Tp-Ts];
 signal = exp(1i*pi*Alpha*(t.^2));
end

